<?php include 'layouts/session.php'; ?>
<?php include 'layouts/head-main.php'; ?>

<head>

    <title>Parcel Booking</title>
    <?php include 'layouts/title-meta.php'; ?>

    <!-- Plugins css -->
    <link href="assets/libs/dropzone/dropzone.css" rel="stylesheet" type="text/css" />

    <?php include 'layouts/head-css.php'; ?>

    <!-- Load New Places Library -->
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyASrmdr17yeq798zEaqhh6YNgTniqi4Tuw&loading=async&libraries=places" async defer></script>
    <script src="https://cdn.lordicon.com/lordicon.js"></script>
    <script src="https://js.pusher.com/8.2/pusher.min.js"></script>

</head>

<?php include 'layouts/body.php'; ?>

<!-- Begin page -->
<div id="layout-wrapper">

    <?php include 'layouts/menu.php'; ?>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Create Parcel Booking</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Menu</a></li>
                                    <li class="breadcrumb-item active">Parcel</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">

                    <div class="col-lg-8">

                        <div class="card">
                            <div class="card-body">

                                <form action="#" class="form-steps" autocomplete="off">

                                    <div class="step-arrow-nav mb-4">

                                        <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link active" id="steparrow-gen-info-tab" data-bs-toggle="pill" data-bs-target="#steparrow-gen-info" type="button" role="tab" aria-controls="steparrow-gen-info" aria-selected="true" data-position="0">Location</button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="steparrow-description-info-tab" data-bs-toggle="pill" data-bs-target="#steparrow-description-info" type="button" role="tab" aria-controls="steparrow-description-info" aria-selected="false" data-position="1" tabindex="-1">Estimation</button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="pills-experience-tab" data-bs-toggle="pill" data-bs-target="#pills-experience" type="button" role="tab" aria-controls="pills-experience" aria-selected="false" data-position="2" tabindex="-1">Finish</button>
                                            </li>
                                        </ul>
                                    </div>

                                    <div class="tab-content">

                                        <div class="tab-pane fade active show" id="steparrow-gen-info" role="tabpanel" aria-labelledby="steparrow-gen-info-tab">
                                            <div class="row">

                                                <div class="col-6">

                                                    <label for="input-from-location" class="form-label">Pick-Up Location</label>
                                                    <input id="input-from-location" class="form-control" placeholder="Enter a place"/>

                                                    <label class="form-label mt-3" for="input-sender-name">Sender Name</label>
                                                    <input id="input-sender-name" class="form-control" placeholder="Write name" value="Nii Sylvester"/>

                                                    <label class="form-label mt-3" for="input-sender-number">Sender Number</label>
                                                    <input id="input-sender-number" class="form-control" placeholder="Write number" value="+27615850125"/>


                                                </div>
                                                <div class="col-6">

                                                    <label for="input-to-location" class="form-label">Destination Location</label>
                                                    <input id="input-to-location" class="form-control" placeholder="Enter a place"/>

                                                    <label class="form-label mt-3" for="input-receiver-name">Receiver Name</label>
                                                    <input id="input-receiver-name" class="form-control" placeholder="Write name" value="Demo"/>

                                                    <label class="form-label mt-3" for="input-receiver-number">Receiver Number</label>
                                                    <input id="input-receiver-number" class="form-control" placeholder="Write number" value="+27615850123"/>

                                                </div>


                                            </div>
                                            <div class="d-flex align-items-start gap-3 mt-4">
                                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab" data-nexttab="steparrow-description-info-tab" id="btn-next-step"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Next Step</button>
                                            </div>
                                        </div>
                                        <!-- end tab pane -->

                                        <div class="tab-pane fade" id="steparrow-description-info" role="tabpanel" aria-labelledby="steparrow-description-info-tab">

                                            <div class="row">

                                                <div class="col-6">

                                                    <label for="choice-vehicle" class="form-label">Vehicles</label>
                                                    <select class="form-control mb-3" data-trigger id="choice-vehicle">
                                                        <option value="">Select Vehicle</option>
                                                    </select>

                                                    <label for="choice-payment-method" class="form-label">Payment Methods</label>
                                                    <select class="form-control mb-3" data-trigger id="choice-payment-method">
                                                        <option value="">Select Payment Method</option>
                                                    </select>

                                                    <label for="input-weight" class="form-label">Estimated Weight</label>
                                                    <input id="input-weight" class="form-control" placeholder="Enter weight"/>

                                                    <div class="text-center">

                                                        <button type="button" class="btn btn-link mt-3" id="btn-estimate">Get Estimation</button>

                                                    </div>


                                                </div>

                                                <div class="col-6">

                                                    <label for="input-distance" class="form-label">Estimated Distance</label>
                                                    <input id="input-distance" class="form-control mb-3" placeholder="Approx. distance"/>

                                                    <label for="input-duration" class="form-label">Estimated Duration</label>
                                                    <input id="input-duration" class="form-control mb-3" placeholder="Approx. duration"/>

                                                    <label for="input-fare" class="form-label">Estimated Price</label>
                                                    <input id="input-fare" class="form-control" placeholder="Approx. price"/>

                                                </div>


                                            </div>

                                            <div class="d-flex align-items-start gap-3 mt-4">
                                                <button type="button" class="btn btn-light btn-label previestab" data-previous="steparrow-gen-info-tab"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Back to Locations</button>
                                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="pills-experience-tab" id="btn-book-ride"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Book Ride</button>
                                            </div>

                                        </div>
                                        <!-- end tab pane -->

                                        <div class="tab-pane fade" id="pills-experience" role="tabpanel" aria-labelledby="pills-experience-tab">
                                            <div class="text-center">

                                                <div class="avatar-md mt-5 mb-4 mx-auto" id="layout-message">

                                                    <div class="text-center">
                                                        <lord-icon
                                                                src="https://cdn.lordicon.com/euaablbm.json"
                                                                trigger="hover"
                                                                stroke="bold"
                                                                style="width:70px;height:70px">
                                                        </lord-icon>
                                                    </div>

                                                </div>
                                                <h5 id="txt-title">Pending !</h5>
                                                <p class="text-muted" id="txt-tagline">Rider did not accept your request until yet</p>
                                            </div>
                                        </div>
                                        <!-- end tab pane -->

                                    </div>
                                    <!-- end tab content -->

                                </form>
                            </div>
                            <!-- end card body -->
                        </div>

                    </div>

                    <div class="col-lg-4">

                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Options</h5>
                            </div>
                            <div class="card-body">

                                <div class="mb-3">
                                    <label for="choice-business" class="form-label">Select Business</label>
                                    <select class="form-control" data-trigger id="choice-business">
                                        <option value="">Select Business</option>
                                    </select>
                                </div>

                                <!--<div class="mb-3">
                                    <label for="choice-group" class="form-label">Select Group</label>
                                    <select data-placeholder="Select Group" class="form-control" data-trigger id="choice-group">
                                        <option value="">Select Group</option>
                                    </select>
                                </div>-->

                                <div class="mb-3">
                                    <label for="choice-user" class="form-label">Select User</label>
                                    <select data-placeholder="Select User" class="form-control" data-trigger id="choice-user">
                                        <option value="">Select User</option>
                                    </select>
                                </div>

                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- end card -->

                    </div>
                    <!-- end col -->

                </div>


            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

        <?php include 'layouts/footer.php'; ?>
    </div>
    <!-- end main content-->

</div>
<!-- END layout-wrapper -->



<?php include 'layouts/customizer.php'; ?>

<?php include 'layouts/vendor-scripts.php'; ?>

<?php include 'layouts/utility-scripts.php'; ?>

<script src="assets/js/pages/add_parcel_booking.init.js"></script>

<!-- App js -->
<script src="assets/js/app.js"></script>
</body>

</html>