/*
Template Name: PosPlatter - Restaurant Pos System
Author: KodingStudio
Website: https://kodingstudio.com/
Contact: contact@kodingstudio.com
*/

let idField = document.getElementById("id-field"),
    inputDeleteId = document.getElementById("input-delete-id"),
    inputBusinessName = document.getElementById("input-business-name"),
    dateField = document.getElementById("date-field"),
    statusField = document.getElementById("status-field"),
    addBtn = document.getElementById("add-btn"),
    editBtn = document.getElementById("edit-btn"),
    deleteRecordBtn = document.getElementById('delete-record');

let
    inputBusinessId = document.getElementById("input-business-id"),
    inputFunds = document.getElementById("input-funds"),
    btnAddFunds = document.getElementById("btn-add-funds");

let statusVal = new Choices(statusField);

let selectorAction = document.getElementById('selector-action');
let choiceAction = new Choices(selectorAction, {
    searchEnabled: false,
    shouldSort: false,
    choices: [
        {
            value: 0,
            label: 'Add'
        },
        {
            value: 1,
            label: 'Subtract'
        }/*,
        {
            value: 2,
            label: 'Adjustment'
        }*/]
});

// list js

let checkAll = document.getElementById("checkAll");
if (checkAll) {
    checkAll.onclick = function () {
        var checkboxes = document.querySelectorAll('.form-check-all input[type="checkbox"]');
        if (checkAll.checked == true) {
            Array.from(checkboxes).forEach(function (checkbox) {
                checkbox.checked = true;
                checkbox.closest("tr").classList.add("table-active");
            });
        } else {
            Array.from(checkboxes).forEach(function (checkbox) {
                checkbox.checked = false;
                checkbox.closest("tr").classList.remove("table-active");
            });
        }
    };
}

let perPage = 8;

//Table
let options = {
    valueNames: [
        "id",
        "business_name",
        "business_funds",
        "total_in",
        "total_out",
        "date",
        "status"
    ],
    page: perPage,
    pagination: true,
    plugins: [
        ListPagination({
            left: 2,
            right: 2
        })
    ]
};

// Init list
let customerList = new List("customerList", options).on("updated", function (list) {
    list.matchingItems.length == 0 ?
        (document.getElementsByClassName("noresult")[0].style.display = "block") :
        (document.getElementsByClassName("noresult")[0].style.display = "none");
    var isFirst = list.i == 1;
    var isLast = list.i > list.matchingItems.length - list.page;
    // make the Prev and Nex buttons disabled on first and last pages accordingly
    (document.querySelector(".pagination-prev.disabled")) ? document.querySelector(".pagination-prev.disabled").classList.remove("disabled") : '';
    (document.querySelector(".pagination-next.disabled")) ? document.querySelector(".pagination-next.disabled").classList.remove("disabled") : '';
    if (isFirst) {
        document.querySelector(".pagination-prev").classList.add("disabled");
    }
    if (isLast) {
        document.querySelector(".pagination-next").classList.add("disabled");
    }
    if (list.matchingItems.length <= perPage) {
        document.querySelector(".pagination-wrap").style.display = "none";
    } else {
        document.querySelector(".pagination-wrap").style.display = "flex";
    }

    if (list.matchingItems.length == perPage) {
        document.querySelector(".pagination.listjs-pagination").firstElementChild.children[0].click()
    }

    if (list.matchingItems.length > 0) {
        document.getElementsByClassName("noresult")[0].style.display = "none";
    } else {
        document.getElementsByClassName("noresult")[0].style.display = "block";
    }
});

document.querySelector("#customerList").addEventListener("click", function() {
    refreshCallbacks();
    //ischeckboxcheck();
});


/* fetch all endpoint */
function fetchAllEndpoint(url = baseUrl + 'v1/web/business/all') {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("GET", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send();

    });

}

/* add endpoint */
function addEndpoint(jsonParam, url = baseUrl + 'v1/web/business/add') {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("POST", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send(JSON.stringify(jsonParam));

    });

}

/* update endpoint */
function updateEndpoint(jsonParam, url) {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("POST", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send(JSON.stringify(jsonParam));

    });

}

/* delete endpoint */
function deleteEndpoint(url) {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("GET", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send();

    });

}

function addFundsEndpoint(jsonParam, url = baseUrl + 'v1/web/business_funds/add') {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("POST", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send(JSON.stringify(jsonParam));

    });

}

fetchAllEndpoint()
    .then(response => JSON.parse(response.data))
    .then(data => {

        Array.from(data.data).forEach(raw => {

            let dateCreated = moment(raw.created_at, "YYYY-MM-DD hh:mm:ss").format("DD MMM, YYYY");

            let totalInAmount = raw.total_in_amount;
            let totalOutAmount = raw.total_out_amount;

            let availAmount = 0;
            if (totalInAmount === totalOutAmount){
                availAmount = totalOutAmount;
            }
            else if (totalInAmount > totalOutAmount) {
                availAmount = totalInAmount - totalOutAmount;
            }

            console.log("Total In Amount "+totalInAmount+" Total Out Amount = "+totalOutAmount+" Avail. = "+availAmount);

            customerList.add({
                id: '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ' + raw.id + "</a>",
                business_name: raw.name,
                business_funds : availAmount +'/'+ totalInAmount,
                total_in: raw.total_in_amount,
                total_out: raw.total_out_amount,
                date: dateCreated,
                status: isStatus(raw.enable)
            });

        });

        customerList.remove("id", '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ2101</a>');
        customerList.sort('id', {order: "desc"});
        addActiveClassToCheckbox();
        refreshCallbacks();


    })
    .catch(error => {

        if (error.data == null)
            return;

        let data = JSON.parse(error.data);
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: data.message,
            showConfirmButton: false,
            timer: 2000,
            showCloseButton: true
        });
        customerList.remove("id", '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ2101</a>');

    });

btnAddFunds.addEventListener("click", function (e) {
    ///console.log("Add Quantity "+inputMetaId.value);

    if (inputFunds.value !== "" &&
        choiceAction.getValue(true) !== "" ) {

        let itemId = "#VZ"+inputBusinessId.value;
        var editValues = customerList.get({
            id: itemId
        });
        Array.from(editValues).forEach(function (x) {
            isid = new DOMParser().parseFromString(x._values.id, "text/html");
            var selectedid = isid.body.firstElementChild.innerHTML;
            if (selectedid === itemId) {

                addFundsEndpoint({
                    business_id: inputBusinessId.value,
                    amount: inputFunds.value,
                    type: choiceAction.getValue(true),
                })
                    .then(response => JSON.parse(response.data))
                    .then(data => {

                        let dataObject = data.data;
                        
                        /*let dateCreated = moment(dataObject.created_at, "YYYY-MM-DD hh:mm:ss").format("DD MMM, YYYY");

                        customerList.add({
                            id: '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ' + dataObject.id + "</a>",

                            item_id: choiceItem.getValue()['value'],
                            item_name: choiceItem.getValue()['label'],

                            branch_id: choiceBranch.getValue()['value'],
                            branch_name: choiceBranch.getValue()['label'],

                            date: dateCreated,
                            status: isStatus(statusField.value),
                        });

                        customerList.sort('id', {order: "desc"});
                        clearFields();
                        filterContact("All");
                        refreshCallbacks();*/

                        let totalIn = parseInt(x._values.total_in);
                        let totalOut = parseInt(x._values.total_out);

                        console.log("Total In = "+totalIn+" Total Out = "+totalOut);

                        if (choiceAction.getValue(true)===0){

                            totalIn += parseInt(inputFunds.value);

                        }
                        else if (choiceAction.getValue(true)===1 ||
                            choiceAction.getValue(true)===2){

                            totalOut += parseInt(inputFunds.value);

                        }

                        console.log("Total In = "+totalIn+" Total Out = "+totalOut);

                        x.values({
                            total_in : totalIn,
                            total_out : totalOut,
                            business_funds : totalIn - totalOut+"/"+totalIn
                        });

                        inputFunds.value = "";
                        inputBusinessId.value = "";
                        choiceAction.setChoiceByValue("");

                        document.getElementById("close-modal-add").click();

                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'Added successfully!',
                            showConfirmButton: false,
                            timer: 2000,
                            showCloseButton: true
                        });

                    })
                    .catch(error => {

                        let data = JSON.parse(error.data);
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: data.message,
                            showConfirmButton: false,
                            timer: 2000,
                            showCloseButton: true
                        });

                    });


            }
        });

    }

});
addBtn.addEventListener("click", function (e) {

    if (inputBusinessName.value !== ""
        && dateField.value !== ""
        && statusVal.getValue(true) !== "") {

        let dateCreated = moment(dateField.value, "DD MMM, YYYY").format("YYYY-MM-DD hh:mm:ss");
        addEndpoint({
            name: inputBusinessName.value,
            enable: getStatus(statusField.value),
            date_created: dateCreated
        })
            .then(response => JSON.parse(response.data))
            .then(data => {

                let categoryObject = data.data;

                customerList.add({
                    id: '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ' + categoryObject.id + "</a>",
                    business_name: inputBusinessName.value,
                    business_funds: '0/0',
                    total_in: '0',
                    total_out: '0',
                    date: dateField.value,
                    status: isStatus(statusField.value),
                });

                customerList.sort('id', {order: "desc"});
                document.getElementById("close-modal").click();
                clearFields();
                filterContact("All");
                refreshCallbacks();


                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Added successfully!',
                    showConfirmButton: false,
                    timer: 2000,
                    showCloseButton: true
                });


            })
            .catch(error => {

                if (error.data == null)
                    return;

                let data = JSON.parse(error.data);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: data.message,
                    showConfirmButton: false,
                    timer: 2000,
                    showCloseButton: true
                });
                customerList.remove("id", '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ2101</a>');

            });

    }
});
editBtn.addEventListener("click", function (e) {

    let itemId = idField.value;
    var editValues = customerList.get({
        id: itemId
    });
    Array.from(editValues).forEach(function (x) {
        isid = new DOMParser().parseFromString(x._values.id, "text/html");
        var selectedid = isid.body.firstElementChild.innerHTML;
        if (selectedid === itemId) {

            let dateCreated = moment(dateField.value, "DD MMM, YYYY").format("YYYY-MM-DD hh:mm:ss");
            let id = itemId.replace('#VZ', '');
            updateEndpoint({
                    name : inputBusinessName.value,
                    enable : getStatus(statusField.value),
                    date_created : dateCreated
                },
                baseUrl + 'v1/web/business/update/'+id)
                .then(response => JSON.parse(response.data))
                .then(data => {

                    x.values({
                        id: '<a href="javascript:void(0);" class="fw-medium link-primary">' + idField.value + "</a>",
                        business_name: inputBusinessName.value,
                        date: dateField.value,
                        status: isStatus(statusField.value),
                    });

                    document.getElementById("close-modal").click();
                    clearFields();
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Updated Successfully!',
                        showConfirmButton: false,
                        timer: 2000,
                        showCloseButton: true
                    });

                })
                .catch(error => {

                    let data = JSON.parse(error.data);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: data.message,
                        showConfirmButton: false,
                        timer: 2000,
                        showCloseButton: true
                    });

                })

        }
    });

});
deleteRecordBtn.addEventListener("click", function () {

    let id = inputDeleteId.value;
    deleteEndpoint(baseUrl + 'v1/web/business/delete/' + id.replace('#VZ', ''))
        .then(response => JSON.parse(response.data))
        .then(data => {

            customerList.remove("id", '<a href="javascript:void(0);" class="fw-medium link-primary">' + id + '</a>');
            document.getElementById("deleteRecordModal").click();
            Swal.fire({
                position: 'center',
                icon: 'success',
                title: data.message,
                showConfirmButton: false,
                timer: 2000,
                showCloseButton: true
            });
            clearFields();

        })
        .catch(error => {

            let data = JSON.parse(error.data);
            Swal.fire({
                position: 'center',
                icon: 'error',
                title: data.message,
                showConfirmButton: false,
                timer: 2000,
                showCloseButton: true
            });

        });

});

document.querySelector(".pagination-next").addEventListener("click", function () {
    (document.querySelector(".pagination.listjs-pagination")) ? (document.querySelector(".pagination.listjs-pagination").querySelector(".active")) ?
        document.querySelector(".pagination.listjs-pagination").querySelector(".active").nextElementSibling.children[0].click() : '' : '';
});
document.querySelector(".pagination-prev").addEventListener("click", function () {
    (document.querySelector(".pagination.listjs-pagination")) ? (document.querySelector(".pagination.listjs-pagination").querySelector(".active")) ?
        document.querySelector(".pagination.listjs-pagination").querySelector(".active").previousSibling.children[0].click() : '' : '';
});

document.getElementById("showModal").addEventListener("show.bs.modal", function (e) {
    if (e.relatedTarget.classList.contains("edit-item-btn")) {
        document.getElementById("exampleModalLabel").innerHTML = "Edit Business";
        document.getElementById("showModal").querySelector(".modal-footer").style.display = "block";
        document.getElementById("add-btn").style.display = "none";
        document.getElementById("edit-btn").style.display = "block";
    }
    else if (e.relatedTarget.classList.contains("add-btn")) {
        document.getElementById("exampleModalLabel").innerHTML = "Add Business";
        document.getElementById("showModal").querySelector(".modal-footer").style.display = "block";
        document.getElementById("edit-btn").style.display = "none";
        document.getElementById("add-btn").style.display = "block";
    }
    else {
        document.getElementById("exampleModalLabel").innerHTML = "List Country";
        document.getElementById("showModal").querySelector(".modal-footer").style.display = "none";
    }
});
document.getElementById("showModal").addEventListener("hidden.bs.modal", function () {
    clearFields();
});

/* filter data using any specific value*/
function filterContact(isValue) {
    var values_status = isValue;
    customerList.filter(function (data) {
        var statusFilter = false;
        matchData = new DOMParser().parseFromString(
            data.values().status,
            "text/html"
        );
        var status = matchData.body.firstElementChild.innerHTML;
        if (status == "All" || values_status == "All") {
            statusFilter = true;
        } else {
            statusFilter = status == values_status;
        }
        return statusFilter;
    });

    customerList.update();
}

/* searching the data in the table*/
function SearchData() {

    var isstatus = document.getElementById("idStatus").value;
    var pickerVal = document.getElementById("datepicker-range").value;

    var date1 = '';
    var date2 = '';

    if (pickerVal.includes("to")) {

        date1 = pickerVal.split(" to ")[0];
        date2 = pickerVal.split(" to ")[1];

    } else {
        date1 = pickerVal;
    }


    customerList.filter(function (data) {
        matchData = new DOMParser().parseFromString(data.values().status, 'text/html');
        var status = matchData.body.firstElementChild.innerHTML;
        var statusFilter = false;
        var dateFilter = false;

        if (status == 'all' || isstatus == 'all') {
            statusFilter = true;
        } else {
            statusFilter = status == isstatus;
        }

        if (new Date(data.values().date.slice(0, 12)) >= new Date(date1) && new Date(data.values().date.slice(0, 12)) <= new Date(date2)) {
            dateFilter = true;
        } else {
            dateFilter = false;
        }

        if (statusFilter && dateFilter) {
            return statusFilter && dateFilter
        } else if (statusFilter && pickerVal == "") {
            return statusFilter
        } else if (dateFilter && pickerVal == "") {
            return dateFilter
        }
    });
    customerList.update();
}

/* clear the dialog fields*/
function clearFields() {
    inputBusinessName.value = "";
    statusVal.setChoiceByValue("");
    dateField.value = "";
}

/* delete the multiple data from list*/
function deleteMultiple() {
    ids_array = [];
    var items = document.getElementsByName('chk_child');
    Array.from(items).forEach(function (ele) {
        if (ele.checked == true) {
            var trNode = ele.parentNode.parentNode.parentNode;
            var id = trNode.querySelector('.id a').innerHTML;
            ids_array.push(id);
        }
    });
    if (typeof ids_array !== 'undefined' && ids_array.length > 0) {
        if (confirm('Are you sure you want to delete this?')) {
            Array.from(ids_array).forEach(function (id) {
                customerList.remove("id", `<a href="javascript:void(0);" class="fw-medium link-primary">${id}</a>`);
            });
            document.getElementById('checkAll').checked = false;
        } else {
            return false;
        }
    } else {
        Swal.fire({
            title: 'Please select at least one checkbox',
            confirmButtonClass: 'btn btn-info',
            buttonsStyling: false,
            showCloseButton: true
        });
    }
}

/* get the decorated status regaridng status value*/
function isStatus(val) {
    switch (val) {
        case "Active":
            return (
                '<span class="badge badge-soft-success text-uppercase">' +
                val +
                "</span>"
            );
        case "Block":
            return (
                '<span class="badge badge-soft-danger text-uppercase">' +
                val +
                "</span>"
            );

        case "0":
        case 0:
            return (
                '<span class="badge badge-soft-success text-uppercase">' +
                'Active' +
                "</span>"
            );
        case "1":
        case 1:
            return (
                '<span class="badge badge-soft-danger text-uppercase">' +
                'Block' +
                "</span>"
            );
    }
}

function getStatus(val) {
    switch (val) {
        case "Active":
            return 0;
        case "Block":
            return 1;
    }
}

/* Add click listener to checkbox
 also attach/remove the active class into checkbox */
function addActiveClassToCheckbox() {
    Array.from(document.getElementsByName("checkAll")).forEach(function (x) {
        x.addEventListener("click", function (e) {
            if (e.target.checked) {
                e.target.closest("tr").classList.add("table-active");
            } else {
                e.target.closest("tr").classList.remove("table-active");
            }
        });
    });
}

/* Attach the listeners to delete/edit buttons of table */
function refreshCallbacks() {

    Array.from(document.getElementsByClassName("remove-item-btn")).forEach(function (btn) {

        if (btn.getAttribute('listener') !== 'true') {

            btn.setAttribute('listener', 'true');
            btn.addEventListener("click", function (e) {
                e.target.closest("tr").children[1].innerText;
                let itemId = e.target.closest("tr").children[1].innerText;
                var itemValues = customerList.get({
                    id: itemId,
                });

                Array.from(itemValues).forEach(function (x) {
                    deleteid = new DOMParser().parseFromString(x._values.id, "text/html");

                    var isElem = deleteid.body.firstElementChild;
                    var isdeleteid = deleteid.body.firstElementChild.innerHTML;

                    if (isdeleteid === itemId) {

                        inputDeleteId.value = isdeleteid;

                    }
                });
            });

        }

    });
    Array.from(document.getElementsByClassName("edit-item-btn")).forEach(function (btn) {

        if (btn.getAttribute('listener') !== 'true') {


            btn.setAttribute('listener', 'true');
            btn.addEventListener("click", function (e) {
                e.target.closest("tr").children[1].innerText;
                let itemId = e.target.closest("tr").children[1].innerText;
                var itemValues = customerList.get({
                    id: itemId,
                });

                Array.from(itemValues).forEach(function (x) {
                    isid = new DOMParser().parseFromString(x._values.id, "text/html");
                    var selectedid = isid.body.firstElementChild.innerHTML;
                    if (selectedid === itemId) {

                        idField.value = selectedid;

                        inputBusinessName.value = x._values.business_name;
                        dateField.value = x._values.date;

                        if (statusVal) statusVal.destroy();
                        statusVal = new Choices(statusField, {
                            searchEnabled: false
                        });
                        val = new DOMParser().parseFromString(x._values.status, "text/html");
                        var statusSelec = val.body.firstElementChild.innerHTML;
                        statusVal.setChoiceByValue(statusSelec);

                        flatpickr("#date-field", {
                            enableTime: true,
                            dateFormat: "d M, Y",
                            defaultDate: x._values.date,
                        });

                    }
                });
            });

        }

    });
    Array.from(document.getElementsByClassName("add-item-btn")).forEach(function (btn) {

        if (btn.getAttribute('listener') == 'false') {

            btn.setAttribute('listener', 'true');
            btn.addEventListener("click", function (e) {

                let itemIdRemove = e.target.closest("tr").children[1].innerText;
                let itemValuesRemove = customerList.get({
                    id: itemIdRemove,
                });

                Array.from(itemValuesRemove).forEach(function (x) {

                    let idDelete = new DOMParser().parseFromString(x._values.id, "text/html");
                    let isdeleteid = idDelete.body.firstElementChild.innerHTML;

                    if (isdeleteid === itemIdRemove) {

                        //inputDeleteId.value = isdeleteid;

                        inputBusinessId.value = isdeleteid.replace('#VZ', '');

                        ///console.log("Id = "+isdeleteid.replace('#VZ', ''));

                    }

                });

            });

        }

    });

}


