/*
Product Name: PosPlatter
Author: KodingStudio
Website: https://kodingstudio.com/
Contact: contact@kodingstudio.com
*/


let inputOldPassword = document.getElementById("input-old-password"),
    inputPassword = document.getElementById("input-password"),
    inputUpdatePassword = document.getElementById("input-update-password"),
    btnClosePassword = document.getElementById('btn-close-password'),
    btnUpdatePassword = document.getElementById("btn-update-password"),
    offCanvasPassword = document.getElementById('offCanvasPassword'),
    canvasPassword = new bootstrap.Offcanvas(offCanvasPassword);

/* update password endpoint */
function updatePasswordEndpoint(jsonParam, url) {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("POST", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send(JSON.stringify(jsonParam));

    });

}

document.getElementById('offCanvasPassword')
    .addEventListener('hidden.bs.offcanvas', function () {

        inputOldPassword.value = '';
        inputPassword.value = '';
        inputUpdatePassword.value = '';

    });

btnUpdatePassword.addEventListener('click', function () {

    if (inputPassword.value === inputUpdatePassword.value) {

        updatePasswordEndpoint({
            old_password: btoa(inputOldPassword.value),
            new_password: btoa(inputPassword.value)
        }, baseUrl + 'v1/web/restaurant/user/update/password')
            .then(response => JSON.parse(response.data))
            .then(data => {

                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: data.message,
                    showConfirmButton: false,
                    timer: 2000,
                    showCloseButton: true
                });
                canvasPassword.toggle();

            })
            .catch(error => {
                let data = JSON.parse(error.data);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: data.message,
                    showConfirmButton: false,
                    timer: 2000,
                    showCloseButton: true
                });
            });


    }
    else {
        alert('New and confirm password are not same, it would be same');
    }

});

