function moveToNext(elem, count) {
    if (elem.value.length > 0) {
        document.getElementById("digit" + count + "-input").focus();
    }
}

function verifyEmail(jsonParam, url) {

    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200) {
                resolve(this.responseText);
            } else {
                reject({code: status, response: this.responseText});
            }

        };
        xhttp.open("POST", url, true);
        xhttp.setRequestHeader('Content-type', 'application/json');
        xhttp.send(JSON.stringify(jsonParam));

    });

}

const searchParams = new URLSearchParams(window.location.search);
if (searchParams.has('id')
    && searchParams.has('email')
    && searchParams.has('type')) {

    let userId = searchParams.get('id');
    let userEmail = searchParams.get('email');
    let type = searchParams.get('type');

    document.getElementById('span-email').innerText = userEmail;

    let btnContinue = document.getElementById('btn-continue');
    btnContinue.addEventListener('click', function () {


        let code = '';
        for (let i=1; i<5; i++) {
            code += document.getElementById("digit" + i + "-input").value;
            console.log("Coe = "+code);
        }


        let endpointUrl = baseUrl + "v1/web/auth/verify/" + userId;
        verifyEmail({

                email: userEmail,
                code: code,
                verify_type : type

            },
            endpointUrl)
            .then(response => JSON.parse(response))
            .then(data => {

                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title : 'Success',
                    showConfirmButton: false,
                    timer: 2000,
                    showCloseButton: true
                }).then((result) => {

                    if (type==="register"){
                        window.location.replace('login.php');
                    }
                    else if (type==="forgot"){
                        window.location.replace('reset_password.php?id='+userId+"&email="+userEmail+"&code="+code);
                    }


                });


            })
            .catch(error => {

                let responseData = JSON.parse(error.response);

                document.getElementById('div-message').innerText = responseData.message;
                document.getElementById('div-message').style.display = 'block';
                document.getElementById('myIcon').classList.remove('ri-loader-2-line');
                document.getElementById('myIcon').classList.add('ri-arrow-right-line');

            });

    });


}