/* get specific cookie from cookies db*/
function getCookie(cname) {
    let name = cname + "=";
    let decodedCookie = decodeURIComponent(document.cookie);
    let ca = decodedCookie.split(';');
    for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function parseResponseCode(code) {

    if (code === "200" || code === "201")
        return true;
    else if (code === "210") {
        removeAllCookies();
        return false;
    } else if (code === "211") {
        alert("Permission denied !! You didn't have any access regarding such functionality");
        return false;
    } else if (code === "212") {
        alert("Contact owner, your package didn't enable you add multiple restaurants");
        return false;
    } else
        return false;

}

function parseResponse(responseObject) {
    let code = responseObject.code;

    if (code === "200" || code === "201")
        return true;
    else if (code === "210") {
        removeAllCookies();
        return false;
    } else if (code === "204" || code === "400" || code === "401"
        || code === "403" || code === "404" || code === "409"
        || code === "500") {

        let responseData = JSON.parse(responseObject.data);
        console.log(responseData.message);
        alert(responseData.message);

        return false;
    } else
        return false;

}

function getAccessType(accessTypeId) {

    switch (accessTypeId) {
        case '1':
            return 'Admin';
        case '2':
            return 'Agent';
        case '5':
            return 'Manager';
    }
}

function isEmpty(str) {
    return (!str || str.length === 0);
}

function groupBy(objectArray, property) {
    return objectArray.reduce(function (acc, obj) {
        var key = obj[property];
        if (!acc[key]) {
            acc[key] = [];
        }
        acc[key].push(obj);
        return acc;
    }, {});
}